﻿
#Область ОбработчикиМетодовHTTP

Функция EventPOST(Запрос)
	
	ТелоЗапроса = РаскодироватьСтроку(Запрос.ПолучитьТелоКакСтроку(), СпособКодированияСтроки.КодировкаURL);
	
	Если НЕ ЗначениеЗаполнено(ТелоЗапроса) Тогда // Проверочный запрос при первом подключении webhook в личном кабинете.
		Возврат НовыйHTTPСервисОтвет(Запрос.Заголовки, 200);
	КонецЕсли;
	
	ИмяСобытияДляЖурналаРегистрации = "/event";
	
	ТелефонияПереопределяемый.ЗаписатьЗапросВЖурналРегистрации(ИмяСобытияДляЖурналаРегистрации, ТелоЗапроса);
	
	ЧтениеJSON = Новый ЧтениеJSON;
	ЧтениеJSON.УстановитьСтроку(ТелоЗапроса);
	ПараметрыЗапроса = ПрочитатьJSON(ЧтениеJSON,, "Timestamp", ФорматДатыJSON.ISO);
	ЧтениеJSON.Закрыть();
	
	Если НЕ КорректныйКлюч(ПараметрыЗапроса.ApiKey) Тогда
		Возврат СообщениеОбОшибке(
			Запрос.Заголовки,
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Некорректный ApiKey'")));
	КонецЕсли;
	
	ОбязательныеПараметры = "EventType";
	Если НЕ ЕстьОбязательныеПараметры(ПараметрыЗапроса, ОбязательныеПараметры) Тогда
		Возврат СообщениеОбОшибке(
			Запрос.Заголовки,
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
	КонецЕсли;
	
	ТипСобытия = ПараметрыЗапроса.EventType;
	
	Попытка
		
		// Появление нового входящего звонка со внешнего номера {From} на бизнес номер {To}
		Если ТипСобытия = "IncomingCall" Тогда
			
			ТелефонияСервер.ОбработатьВходящийЗвонок(
				ПараметрыЗапроса.Body.From,
				ПараметрыЗапроса.Body.To,
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Id,
				Истина,
				Ложь,
				ПараметрыЗапроса.Body.To);
			
		// Начало дозвона до пользователя с указанным добавочным номером {Extension}
		ИначеЕсли ТипСобытия = "IncomingCallRinging" Тогда
			
			ТелефонияСервер.ОбработатьВходящийЗвонок(
				ПараметрыЗапроса.Body.From,
				ПараметрыЗапроса.Body.Extension,
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Id,
				Ложь);
			
		// Неуспешная попытка дозвона до пользователя с добавочным номером {Extension}
		ИначеЕсли ТипСобытия = "IncomingCallStopRinging" Тогда 
			
		// Успешное соединение с пользователем с добавочным номером {Extension}
		ИначеЕсли ТипСобытия = "IncomingCallConnected" Тогда
			
			ТелефонияСервер.ОбработатьИзменениеЗвонка(
				ПараметрыЗапроса.Body.Id,
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Extension);
			
		// Завершение входящего звонка
		ИначеЕсли ТипСобытия = "IncomingCallCompleted" Тогда
			
			ТелефонияСервер.ОбработатьЗавершениеЗвонка(,,,
				ПараметрыЗапроса.Timestamp,,,,
				Истина,
				ПараметрыЗапроса.Body.Id);
			
		// Начало исходящего звонка с бизнес номера {From} на внешний номер {To} пользователем с добавочным номером {Extension}
		ИначеЕсли ТипСобытия = "OutgoingCall" Тогда
			
			ТелефонияСервер.ОбработатьИсходящийЗвонок(
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Extension,,
				ПараметрыЗапроса.Body.To,
				ПараметрыЗапроса.Body.Id);
			
		// Начало разговора при исходящем звонке
		ИначеЕсли ТипСобытия = "OutgoingCallConnected" Тогда
			
			ТелефонияСервер.ОбработатьИзменениеЗвонка(
				ПараметрыЗапроса.Body.Id,
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Extension);
			
		// Завершение исходящего звонка
		ИначеЕсли ТипСобытия = "OutgoingCallCompleted" Тогда
			
			ТелефонияСервер.ОбработатьЗавершениеЗвонка(,,,
				ПараметрыЗапроса.Timestamp,,,,
				Истина,
				ПараметрыЗапроса.Body.Id);
			
		// Появление заявки на обратный звонок с бизнес номера {From} на внешний номер {To}
		ИначеЕсли ТипСобытия = "CallbackCall" Тогда
			
		// Начало дозвона до пользователя с указанным добавочным номером {Extension} при обратном звонке
		ИначеЕсли ТипСобытия = "CallbackCallRinging" Тогда
			
		// Неуспешная попытка дозвона до пользователя с добавочным номером {Extension} при обратном звонке
		ИначеЕсли ТипСобытия = "CallbackCallStopRinging" Тогда
			
		// Пользователь с добавочным номером {Extension} соединился с номером {To} при обратном звонке
		ИначеЕсли ТипСобытия = "CallbackCallConnected" Тогда
			
		// Завершение обратного звонка
		ИначеЕсли ТипСобытия = "CallbackCallCompleted" Тогда
			
		КонецЕсли;
		
	Исключение
		Возврат СообщениеОбОшибке(
			Запрос.Заголовки,
			500,
			ИмяСобытияДляЖурналаРегистрации,
			ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
	КонецПопытки;
	
	Возврат НовыйHTTPСервисОтвет(Запрос.Заголовки, 200);
	
КонецФункции

Функция pingGET(Запрос)
	
	Ответ = Новый HTTPСервисОтвет(200);
	Ответ.УстановитьТелоИзСтроки("ok");
	Возврат Ответ;
	
КонецФункции

#КонецОбласти

#Область СлужебныеПроцедурыИФункции

Функция КорректныйКлюч(ПолученныйКлюч)
	
	УстановитьПривилегированныйРежим(Истина);
	
	КлючДляАвторизации = ТелефонияСервер.ПолучитьНастройкиТелефонии().КлючДляАвторизацииАТСЯндекс;
	Возврат ПолученныйКлюч = КлючДляАвторизации;
	
КонецФункции

Функция ЕстьОбязательныеПараметры(ПараметрыЗапроса, ОбязательныеПараметры)
	
	МассивПараметров = СтроковыеФункцииКлиентСервер.РазложитьСтрокуВМассивПодстрок(ОбязательныеПараметры);
	
	Для Каждого ОбязательныйПараметр Из МассивПараметров Цикл
		Если НЕ ПараметрыЗапроса.Свойство(ОбязательныйПараметр) Тогда
			Возврат Ложь;
		КонецЕсли;
	КонецЦикла;
	
	Возврат Истина;
	
КонецФункции

Функция СообщениеОбОшибке(ЗаголовкиВходящегоЗапроса, КодСостояния, ВложенноеИмяСобытия, Комментарий = Неопределено)
	
	ЗаписьЖурналаРегистрации(
		ТелефонияПереопределяемый.СобытиеЖурналаРегистрации() + "." + ВложенноеИмяСобытия,
		УровеньЖурналаРегистрации.Ошибка,,,
		Комментарий);
	
	Возврат НовыйHTTPСервисОтвет(ЗаголовкиВходящегоЗапроса, КодСостояния);
	
КонецФункции

Функция НовыйHTTPСервисОтвет(ЗаголовкиВходящегоЗапроса, КодСостояния)
	
	Ответ = Новый HTTPСервисОтвет(КодСостояния);
	
	ПодписьКлюч = "Echo";
	ПодписьЗначение = ЗаголовкиВходящегоЗапроса.Получить(ПодписьКлюч);
	Если ПодписьЗначение <> Неопределено Тогда
		Ответ.Заголовки.Вставить(ПодписьКлюч, ПодписьЗначение);
	КонецЕсли;
	
	Возврат Ответ;
	
КонецФункции

#КонецОбласти
