﻿
#Область ОбработчикиМетодовHTTP

Функция EventPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/event";
	
	ТелоЗапроса = РаскодироватьСтроку(Запрос.ПолучитьТелоКакСтроку(), СпособКодированияСтроки.КодировкаURL);
	ТелефонияПереопределяемый.ЗаписатьЗапросВЖурналРегистрации(ИмяСобытияДляЖурналаРегистрации, ТелоЗапроса);
	
	ПараметрыТела = ПолучитьПараметрыИзСтроки(ТелоЗапроса, "&");
	
	Если НЕ КорректныйКлюч(ПараметрыТела.crm_token) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Некорректный ключ'"));
	КонецЕсли;
	
	ОбязательныеПараметры = "cmd";
	Если НЕ ЕстьОбязательныеПараметры(ПараметрыТела,ОбязательныеПараметры) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
	КонецЕсли;
	
	ТипОперации = ПараметрыТела.cmd;
	Ответ = Неопределено;
	
	Попытка
		
		Если ТипОперации = "contact" Тогда
			
			ОбязательныеПараметры = "phone";
			Если НЕ ЕстьОбязательныеПараметры(ПараметрыТела, ОбязательныеПараметры) Тогда
				Возврат СообщениеОбОшибке(
					400,
					ИмяСобытияДляЖурналаРегистрации,
					СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
			КонецЕсли;
			
			ДанныеАбонента = ТелефонияСервер.ПолучитьДанныеКлиента(ПараметрыТела.phone);
			
			ЗаписьJSON = Неопределено;
			Если ДанныеАбонента <> Неопределено Тогда
				
				ЗаписьJSON = Новый ЗаписьJSON;
				ЗаписьJSON.УстановитьСтроку(Новый ПараметрыЗаписиJSON(ПереносСтрокJSON.Нет));
				ЗаписьJSON.ЗаписатьНачалоОбъекта();
				
				ЗаписьJSON.ЗаписатьИмяСвойства("contact_name");
				ЗаписьJSON.ЗаписатьЗначение(ДанныеАбонента.Представление);
				
				Если ДанныеАбонента.Свойство("ВнутреннийНомерОтветственного") Тогда
					ЗаписьJSON.ЗаписатьИмяСвойства("responsible");
					ЗаписьJSON.ЗаписатьЗначение(ДанныеАбонента.ВнутреннийНомерОтветственного);
				КонецЕсли;
				
				ЗаписьJSON.ЗаписатьКонецОбъекта();
				ПараметрыОтвета = ЗаписьJSON.Закрыть();
				
			КонецЕсли;
			
			Ответ = Новый HTTPСервисОтвет(200);
			Если ЗаписьJSON <> Неопределено Тогда
				Ответ.УстановитьТелоИзСтроки(ПараметрыОтвета);
			КонецЕсли;
			
		ИначеЕсли ТипОперации = "history" Тогда
			
			ОбязательныеПараметры = "callid";
			Если НЕ ЕстьОбязательныеПараметры(ПараметрыТела, ОбязательныеПараметры) Тогда
				Возврат СообщениеОбОшибке(
					400,
					ИмяСобытияДляЖурналаРегистрации,
					СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
			КонецЕсли;
			
			ТелефонияСервер.ОбработатьЗавершениеЗвонка(
				,,,,
				Число(ПараметрыТела.duration),,
				?(ПараметрыТела.Свойство("link"), ПараметрыТела.link, ""),,
				ПараметрыТела.callid,
				Ложь
			);
			
		ИначеЕсли ТипОперации = "event" Тогда
			
			ОбязательныеПараметры = "type,callid,phone,ext";
			Если НЕ ЕстьОбязательныеПараметры(ПараметрыТела, ОбязательныеПараметры) Тогда
				Возврат СообщениеОбОшибке(
					400,
					ИмяСобытияДляЖурналаРегистрации,
					СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
			КонецЕсли;
			
			Если НРег(ПараметрыТела.type) = "incoming" Тогда
				
				УстановитьПривилегированныйРежим(Истина);
				
				МенеджерЗаписи = РегистрыСведений.ДанныеЗвонков.СоздатьМенеджерЗаписи();
				МенеджерЗаписи.ИдентификаторЗвонкаВАТС = ПараметрыТела.callid;
				МенеджерЗаписи.Прочитать();
				
				РегистрироватьЗвонок = Ложь;
				
				Если НЕ МенеджерЗаписи.Выбран() Тогда
					МенеджерЗаписи.ИдентификаторЗвонкаВАТС = ПараметрыТела.callid;
					МенеджерЗаписи.Записать();
					
					РегистрироватьЗвонок = Истина;
					
				КонецЕсли;
				
				УстановитьПривилегированныйРежим(Ложь);
				
				НомерОрганизации = Неопределено;
				ПараметрыТела.Свойство("diversion", НомерОрганизации);
				
				ТелефонияСервер.ОбработатьВходящийЗвонок(
					ПараметрыТела.phone,
					ПараметрыТела.ext,
					ТекущаяДатаСеанса(),
					ПараметрыТела.callid,
					РегистрироватьЗвонок,
					Истина,
					НомерОрганизации
				);
			ИначеЕсли НРег(ПараметрыТела.type) = "outgoing" Тогда
				ТелефонияСервер.ОбработатьИсходящийЗвонок(
					ТекущаяДатаСеанса(),
					ПараметрыТела.ext,,
					ПараметрыТела.phone,
					ПараметрыТела.callid,
					ТекущаяДатаСеанса()
				);
			ИначеЕсли НРег(ПараметрыТела.type) = "accepted" Тогда
				ТелефонияСервер.ОбработатьИзменениеЗвонка(
					ПараметрыТела.callid,
					ТекущаяДатаСеанса(),
					ПараметрыТела.ext
				);
			ИначеЕсли НРег(ПараметрыТела.type) = "completed" Тогда
				ТелефонияСервер.ОбработатьЗавершениеЗвонка(
					,,,,,
					Ложь,,,
					ПараметрыТела.callid,,
					ПараметрыТела.ext
				);
			ИначеЕсли НРег(ПараметрыТела.type) = "cancelled" Тогда
				ТелефонияСервер.ОбработатьЗавершениеЗвонка(
					,,,,,
					Истина,,,
					ПараметрыТела.callid,,
					ПараметрыТела.ext
				);
			КонецЕсли;
			
		Иначе
			
			Возврат СообщениеОбОшибке(501, ИмяСобытияДляЖурналаРегистрации); // Not implemented
			
		КонецЕсли;
		
	Исключение
		
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
		
	КонецПопытки;
	
	Если Ответ = Неопределено Тогда
		Ответ = Новый HTTPСервисОтвет(200);
	КонецЕсли;
	
	Возврат Ответ;
	
КонецФункции

Функция pingGET(Запрос)
	
	Ответ = Новый HTTPСервисОтвет(200);
	Ответ.УстановитьТелоИзСтроки("ok");
	Возврат Ответ;
	
КонецФункции

#КонецОбласти

#Область СлужебныеПроцедурыИФункции

Функция ПолучитьПараметрыИзСтроки(Знач СтрокаПараметров, Знач Разделитель = ";") Экспорт
	Результат = Новый Структура;
	
	ОписаниеПараметра = "";
	НайденоНачалоСтроки = Ложь;
	НомерПоследнегоСимвола = СтрДлина(СтрокаПараметров);
	Для НомерСимвола = 1 По НомерПоследнегоСимвола Цикл
		Символ =Сред(СтрокаПараметров, НомерСимвола, 1);
		Если Символ = """" Тогда
			НайденоНачалоСтроки = Не НайденоНачалоСтроки;
		КонецЕсли;
		Если Символ <> Разделитель Или НайденоНачалоСтроки Тогда
			ОписаниеПараметра = ОписаниеПараметра + Символ;
		КонецЕсли;
		Если Символ = Разделитель И Не НайденоНачалоСтроки Или НомерСимвола = НомерПоследнегоСимвола Тогда
			Позиция = СтрНайти(ОписаниеПараметра, "=");
			Если Позиция > 0 Тогда
				ИмяПараметра = СокрЛП(Лев(ОписаниеПараметра, Позиция - 1));
				ЗначениеПараметра = СокрЛП(Сред(ОписаниеПараметра, Позиция + 1));
				ЗначениеПараметра = СтроковыеФункцииКлиентСервер.СократитьДвойныеКавычки(ЗначениеПараметра);
				Попытка
					Результат.Вставить(ИмяПараметра, ЗначениеПараметра);
				Исключение
				КонецПопытки;
			КонецЕсли;
			ОписаниеПараметра = "";
		КонецЕсли;
	КонецЦикла;
	
	Возврат Результат;
КонецФункции

Функция КорректныйКлюч(ПолученныйКлюч)
	
	УстановитьПривилегированныйРежим(Истина);
	
	КлючДляАвторизации = ТелефонияСервер.ПолучитьНастройкиТелефонии().КлючДляАвторизацииВУНФ;
	Возврат ПолученныйКлюч = КлючДляАвторизации;
	
КонецФункции

Функция ЕстьОбязательныеПараметры(ПараметрыТела, ОбязательныеПараметры)
	
	МассивПараметров = СтроковыеФункцииКлиентСервер.РазложитьСтрокуВМассивПодстрок(ОбязательныеПараметры);
	
	Для Каждого ОбязательныйПараметр Из МассивПараметров Цикл
		Если НЕ ПараметрыТела.Свойство(ОбязательныйПараметр) Тогда
			Возврат Ложь;
		КонецЕсли;
	КонецЦикла;
	
	Возврат Истина;
	
КонецФункции

Функция СообщениеОбОшибке(КодСостояния, ВложенноеИмяСобытия, Комментарий = Неопределено)
	
	ЗаписьЖурналаРегистрации(
		ТелефонияПереопределяемый.СобытиеЖурналаРегистрации() + "." + ВложенноеИмяСобытия,
		УровеньЖурналаРегистрации.Ошибка,,,
		Комментарий);
	
	Ответ = Новый HTTPСервисОтвет(КодСостояния);
	Возврат Ответ;
	
КонецФункции

#КонецОбласти
